// Set Changer.js

/*

Install:
it's Tool script. Place it into ~/Library/Application Support/Cheetah3D/scripts/Tool folder. then, "Update Script Menu".

Usage:
1. set folder name 'SET***' or 'set***'.
2. select folder name that you want toggle visibility.
3. click 'set' button.
4. you cal also check toggle parameters, visibiel in editor / visible in renderer / active camera

*/

var folders = [];
var folder_sel = [];
var folder_found = false;
var name_match = new RegExp(/^SET.*/i);

function buildUI( tool ) {
	
	createFolders( tool );
	
	tool.addParameterSelector("set", folder_sel, false, false);
	tool.addParameterBool("tgl vis. in editor", 1, 0, 1, false, false);
	tool.addParameterBool("tgl vis. in renderer", 1, 0, 1, false, false);
	tool.addParameterBool("tgl active cam", 1, 0, 1, false, false);
	
	tool.addParameterButton("set","set","changeFolder");
	
}

function changeFolder( tool ) {
	
	var folder_index = parseInt(tool.getParameter("set"));
	
	var tve = tool.getParameter("tgl vis. in editor");
	var tvr = tool.getParameter("tgl vis. in renderer");
	var tac = tool.getParameter("tgl active cam");
	
	if (tac) {
		tool.document().activeCamera().setParameter("activeCamera", false);
	}
	
	if (folder_found) {
		
		for( var i = 0;i < folders.length;i++) {
			var target_folder = folders[i].target_obj;
			var tag = undefined;
			for( var j = 0;j < target_folder.tagCount();j++) {
				if (target_folder.tagAtIndex( j ).type() == 103) {
					tag = target_folder.tagAtIndex( j );
				}
			}
			if (i == folder_index) {
				if (tve) tag.setParameter("editorActive", true);
				if (tvr) tag.setParameter("renderActive", true);
				
				for ( j = 0;j < target_folder.childCount();j++) {
					var child = target_folder.childAtIndex(j);
					if (child.type() == CAMERA) {
						if (tac) child.setParameter("activeCamera",true);
					}
				}
			} else {
				if (tve) tag.setParameter("editorActive", false);
				if (tvr) tag.setParameter("renderActive", false);
				
				for ( j = 0;j < target_folder.childCount();j++) {
					var child = target_folder.childAtIndex(j);
					if (child.type() == CAMERA) {
						if (tac) child.setParameter("activeCamera",false);
					}
				}
			}
			target_folder.update();
		}
		
		
	} else {
		OS.beep();
	}
}

function createFolders( tool ) {
	folders.length = 0;
	folder_sel.length = 0;
	folder_found = false;
	
	cacheFolder( tool.document().root() );
	
	for (var i = 0;i < folders.length;i++) {
		folder_sel.push( folders[i].target_name );
	}
	
	if (folders.length < 0) {
		folder_sel.push( "No SET founds." );
	}
}

function cacheFolder( obj ) {
	
	if ( obj.type() == FOLDER ) {
		var name = obj.getParameter("name");
		
		if (folders.length < 10 && name.match( name_match )) {
			folder_found = true;
			folders.push( { target_obj: obj, target_name: name } );
		}
	}
	
	var len = obj.childCount();
	for ( var i = 0; i < len; i++ ) {
		cacheFolder( obj.childAtIndex( i ) );
	}
}